/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.StringSizeTerminated;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;

public abstract class AbstractFrameBodyUrlLink
extends AbstractID3v2FrameBody {
    protected AbstractFrameBodyUrlLink() {
    }

    protected AbstractFrameBodyUrlLink(AbstractFrameBodyUrlLink body) {
        super(body);
    }

    public AbstractFrameBodyUrlLink(String urlLink) {
        this.setObjectValue("URLLink", urlLink);
    }

    protected AbstractFrameBodyUrlLink(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getUrlLink();
    }

    public void setUrlLink(String urlLink) {
        if (urlLink == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.setObjectValue("URLLink", urlLink);
    }

    public String getUrlLink() {
        return (String)this.getObjectValue("URLLink");
    }

    @Override
    public void write(ByteArrayOutputStream tagBuffer) {
        String origUrl;
        CharsetEncoder encoder = Charset.forName("ISO-8859-1").newEncoder();
        if (!encoder.canEncode(origUrl = this.getUrlLink())) {
            this.setUrlLink(this.encodeURL(origUrl));
            if (!encoder.canEncode(this.getUrlLink())) {
                logger.warning(ErrorMessage.MP3_UNABLE_TO_ENCODE_URL.getMsg(origUrl));
                this.setUrlLink("");
            } else {
                logger.warning(ErrorMessage.MP3_URL_SAVED_ENCODED.getMsg(origUrl, this.getUrlLink()));
            }
        }
        super.write(tagBuffer);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new StringSizeTerminated("URLLink", this));
    }

    private String encodeURL(String url) {
        try {
            String[] splitURL = url.split("(?<!/)/(?!/)", -1);
            StringBuffer sb = new StringBuffer(splitURL[0]);
            for (int i = 1; i < splitURL.length; ++i) {
                sb.append("/").append(URLEncoder.encode(splitURL[i], "utf-8"));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException uee) {
            logger.warning("Uable to url encode because utf-8 charset not available:" + uee.getMessage());
            return url;
        }
    }
}

